<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( ! class_exists( 'MTS_Testimonials_Shortcode_Generator' ) ) :

class MTS_Testimonials_Shortcode_Generator extends MTS_Testimonials {

	var $saved_shortcodes = array();


	function __construct() {
		add_action( 'init', array( $this, 'init' ) );

		add_action( 'wp_ajax_testimonial_save_shortcode', array($this, 'ajax_save_shortcode') );
		add_action( 'wp_ajax_testimonial_delete_shortcode', array($this, 'ajax_delete_shortcode') );
		add_action( 'wp_ajax_testimonial_preview_shortcode', array($this, 'ajax_preview_shortcode') );
	}

	function init() {
		// load up
		$this->saved_shortcodes = get_option( 'mts_testimonials_shortcodes', array() );
	}

	public function ajax_save_shortcode() {
		$shortcode_atts = wp_parse_args( $_POST['shortcode_atts'], array() );
		unset($shortcode_atts['action']);
		$shortcode_name = $_POST['shortcode_name'];
		$this->saved_shortcodes[$shortcode_name] = $shortcode_atts;
		update_option( 'mts_testimonials_shortcodes', $this->saved_shortcodes );

		$this->list_html();
		exit();
	}

	public function ajax_delete_shortcode() {
		$shortcode_name = $_POST['shortcode_name'];
		unset($this->saved_shortcodes[$shortcode_name]);
		update_option( 'mts_testimonials_shortcodes', $this->saved_shortcodes );

		$this->list_html();
		exit();
	}

	public function ajax_preview_shortcode() {
		$shortcode = stripslashes($_POST['shortcode']);
		echo do_shortcode( $shortcode );
		exit();
	}

	public function form_html( $echo = true ) {
		global $mts_testimonials;
		$output = '<form action="'.admin_url('admin-ajax.php').'" method="post">';
		$output .= '<div class="mtsg-options-col">';
		$output .= '<input type="hidden" name="action" value="testimonial_save_shortcode">';
		$layouts = $mts_testimonials->get_layouts();
		$output .= $this->form_field_select('layout', '', $layouts, __('Layout', 'mts-testimonials'));

		$output .= $this->form_field_select('display_by', '', array(
			'query' => __('Query Testimonials'),
			'id' => __('Specific Testimonials')
		), __('Show Testimonials', 'mts-testimonials'));

		$output .= '<div class="mtsg-query-options">';

		$cats = array();
		$terms = get_terms('mts_testimonials_category', array('hide_empty' => false));
		foreach ($terms as $term) {
			$cats[$term->term_id] = $term->name;
		}

		$output .= $this->form_field_select('category', '', (array(
			'0' => __('Any'),
		) + $cats), __('Category', 'mts-testimonials'));

		$output .= $this->form_field_number('number', '3', __('Number', 'mts-testimonials'));
		$output .= $this->form_field_select('order_by', '', array(
			'rand' => __('Random'),
			'date' => __('Latest')
		), __('Order', 'mts-testimonials'));

		$output .= '</div>';

		$output .= '<div class="mtsg-id-options">';
		$testimonials_query = new WP_Query(array('post_type' => 'mts_testimonials', 'posts_per_page' => -1, 'post_status' => 'publish'));
		$testimonials = array();
		if ( $testimonials_query->have_posts() ) {
			while ( $testimonials_query->have_posts() ) {
				$testimonials_query->the_post();
				$testimonials[get_the_ID()] = get_the_title();
			}
		}
		wp_reset_postdata();
		$output .= $this->form_field_select('testimonials', '', $testimonials,__('Select Testimonials', 'mts-testimonials'), null, '', true);

		$output .= '</div>';
		$output .= $this->form_field_number('carousel_transition', '3', __('Carousel Transition (Seconds)', 'mts-testimonials'), null ,'mts_carousel_transition' , 1 , null,null );

		$output .= '</div>'; // .mtsg-options-col
		$output .= '<div class="mtsg-options-col">';

		$output .= $this->form_field_color('color_scheme', '', __('Color Scheme', 'mts-testimonials'));
		$output .= $this->form_field_checkbox('show_title', '1', __('Show Title of the Testimonial', 'mts-testimonials'));
		$output .= $this->form_field_checkbox('show_image', '1', __('Show Image', 'mts-testimonials'));
		$output .= $this->form_field_checkbox('show_rating', '1', __('Show Rating', 'mts-testimonials'));
		$output .= $this->form_field_checkbox('show_position', '1', __('Show Position of the Person', 'mts-testimonials'));

		$output .= '</div>'; // .mtsg-options-col
		$output .= '</form>';

		if ($echo)
			echo $output;
		else
			return $output;
	}

	public function generated_shortcode_html() {
		?>
		<h4><span><?php _e('Your shortcode: ', 'mts-testimonials'); ?></span> <input type="text" class="widefat" id="mtsg-generated-shortcode" readonly="readonly" value="[wp_testimonial]"></h4>

		<?php
	}

	public function preview_html( $echo = true) {
		$shortcode = '[mts_testimonial]';
		if ($echo)
			echo do_shortcode($shortcode);
		else
			return do_shortcode($shortcode);
	}

	public function form_field_text($name, $value, $label = null, $id = null, $class = '') {
		if (!is_string($label))
			$label = ucwords(str_replace(array('_', '-', '–'), ' ', $name));

		if (!is_string($id))
			$id = esc_attr($name);

		$output = '';

		$output .= '<div class="mtsg-field mtsg-field-text field-'.$id.' '.$class.'">';
		$output .= 	'<label for="'.$id.'">';
		$output .= 		'<span>'.$label.'</span>';
		$output .= 		'<input type="text" name="'.$name.'" id="'.$id.'" value="'.$value.'" />';
		$output .= 	'</label>';
		$output .= '</div>';

		return $output;
	}

	public function form_field_number($name, $value, $label = null, $id = null, $class = '' ,$min = null, $max = null, $step = null) {
		if (!is_string($label))
			$label = ucwords(str_replace(array('_', '-', '–'), ' ', $name));

		if (!is_string($id))
			$id = esc_attr($name);

		$output = '';

		$output .= '<div class="mtsg-field mtsg-field-number field-'.$id.' '.$class.'">';
		$output .= 	'<label for="'.$id.'">';
		$output .= 		'<span>'.$label.'</span>';
		$output .= 		'<input type="number" name="'.$name.'" id="'.$id.'" value="'.$value.'" min="'.$min.'" max="'.$max.'" step="'.$step.'" class="small-text" />';
		$output .= 	'</label>';
		$output .= '</div>';

		return $output;
	}
	public function form_field_color($name, $value, $label = null, $id = null, $class = '') {
		if (!is_string($label))
			$label = ucwords(str_replace(array('_', '-', '–'), ' ', $name));

		if (!is_string($id))
			$id = esc_attr($name);

		$output = '';

		$output .= '<div class="mtsg-field mtsg-field-color field-'.$id.' '.$class.'">';
		$output .= 	'<label for="'.$id.'">';
		$output .= 		'<span>'.$label.'</span>';
		$output .= 		'<input type="text" name="'.$name.'" id="'.$id.'" value="'.$value.'" />';
		$output .= 	'</label>';
		$output .= '</div>';

		return $output;
	}
	public function form_field_checkbox($name, $checked, $label = null, $id = null, $class = '') {
		if (!is_string($label))
			$label = ucwords(str_replace(array('_', '-', '–'), ' ', $name));

		if (!is_string($id))
			$id = esc_attr($name);

		$output = '';

		$output .= '<div class="mtsg-field mtsg-field-checkbox field-'.$id.' '.$class.'">';
		$output .= 	'<label for="'.$id.'">';
		$output .= 		'<span>'.$label.'</span>';
		$output .= 		'<input type="hidden" name="'.$name.'" id="'.$id.'-hidden" value="0" />';
		$output .= 		'<input type="checkbox" name="'.$name.'" id="'.$id.'" value="1" '.checked( $checked, 1, 0 ).' />';
		$output .= 	'</label>';
		$output .= '</div>';

		return $output;
	}


	public function form_field_select($name, $value, $options, $label = null, $id = null, $class = '', $multiple = false) {
		if (!is_string($label))
			$label = ucwords(str_replace(array('_', '-', '–'), ' ', $name));

		if (!is_string($id))
			$id = esc_attr($name);

		if (!is_array($options))
			$options = array();

		$output = '';

		$output .= '<div class="mtsg-field mtsg-field-text field-'.$id.' '.$class.'">';
		$output .= 	'<label for="'.$id.'">';
		$output .= 		'<span>'.$label.'</span>';
		$output .= 		'<select name="'.$name.'" id="'.$id.'" '.($multiple ? 'multiple="multiple"' : '').' style="width: 270px;">';
		foreach ($options as $option_value => $option_label) {
			$output .= '<option value="'.$option_value.'" '.selected( $option_value, $value, 0 ).'>'.$option_label.'</option>';
		}
		$output .= 		'</select>';
		$output .= 	'</label>';
		$output .= '</div>';

		return $output;
	}
}

endif;
